﻿$(document).on("pageinit", function () {
    var context = $("[data-questiontype='fileupload']");

    $(".clearFileButton", context).on("click", function () {
        var question = $(this).closest(".questionContainer");

        $(".deleteFile", question).val("delete");
        $(".fileLink", question).remove();
        $(this).hide();
    });

    $(":file", context).on("change",function (event) {
        var question = $(this).closest(".questionContainer");
        var inputFileContainer = $(".inputFileContainer", context);
        var errorMessageDiv = $(".errorMessage", question);
        var maxFileSize = inputFileContainer.attr("data-maxfilesize");

        if (validateFileSize(event, maxFileSize)) {
            errorMessageDiv.hide();
        }
        else {
            var errorMessage = inputFileContainer.attr("data-maxfilesizemessage");

            if (errorMessageDiv.length > 0) {
                errorMessageDiv.show();
                errorMessageDiv.text(errorMessage);
            }
            else {
                question.append($("<div />", { "class": "errorMessageContainer" }).append($("<div />", { "class": "errorMessage" }, {"role": "alert"}).append(errorMessage)));
            }

            $(this).val("");
        }

        $(".deleteFile", question).val("delete").trigger("change");
        $(".fileLink", question).remove();
        $(".clearFileButton", question).hide();
    });
});

function validateFileSize(event, maxFileSize) {
    var fileSize = 0;
    var isValid = true;

    if (event.originalEvent.target.files) {
        var files = event.originalEvent.target.files;
        if (files[0]) {
            fileSize = files[0].size;
        }
    }

    return (fileSize / 1024) <= parseInt(maxFileSize);
}